﻿using System;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;

namespace PWS.API.Window
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern bool GetWindowText(IntPtr hWnd, StringBuilder lpString, int nMaxCount);

        [DllImport("user32.dll")]
        public static extern int GetWindowTextLength(IntPtr hWnd);

        [DllImport("user32.dll")]
        public static extern IntPtr FindWindow(string lpClassName, string lpWindowName);

        public FormMain()
        {
            InitializeComponent();
        }

        private void FormMain_Load(object sender, EventArgs e)
        {
            IntPtr hWnd = FindWindow("Notepad", null);
            if (!hWnd.Equals(IntPtr.Zero))
            {
                StringBuilder lpString = new StringBuilder(100);
                GetWindowText(hWnd, lpString, lpString.Capacity);
                int captionLength = GetWindowTextLength(hWnd);
                MessageBox.Show(String.Format("Title = {0}, TitleLength = {1}", lpString, captionLength));
            }
            else
                MessageBox.Show("Notepad not running");
        }
    }
}